// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Message definitions for program errors for Top Secret Crypto Gold.

// When used with SetLastError, bit 29 must be set to indicate
// to the program to look in its own message table for the
// error definition. 0x20000000. In order to ensure that this is
// the case, use the -c command line argument with MC.EXE.


// The SeverityNames keyword defines the set of names that are allowed
// as the value of the Severity keyword in the message definition. The
// set is delimited by left and right parentheses. Associated with each
// severity name is a number that, when shifted left by 30, gives the
// bit pattern to logical-OR with the Facility value and MessageId
// value to form the full 32-bit message code. The default value of
// this keyword is:


// The FacilityNames keyword defines the set of names that are allowed
// as the value of the Facility keyword in the message definition. The
// set is delimited by left and right parentheses. Associated with each
// facility name is a number that, when shift it left by 16 bits, gives
// the bit pattern to logical-OR with the Severity value and MessageId
// value to form the full 32-bit message code.


// The LanguageNames keyword defines the set of names that are allowed
// as the value of the Language keyword in the message definition. The
// set is delimited by left and right parentheses. Associated with each
// language name is a number and a file name that are used to name the
// generated resource file that contains the messages for that
// language.The number corresponds to the language identifier to use
// in the resource table. The number is separated from the file name
// with a colon.


//-------------------------------------------------------------------------
// MESSAGE DEFINITION SECTION

// Following the header section is the body of the Message Compiler
// source file. The body consists of zero or more message definitions.
// Each message definition begins with one or more of the following
// statements:

// MessageId = [number|+number]
// Severity = severity_name
// Facility = facility_name
// SymbolicName = name

// The MessageId statement marks the beginning of the message
// definition. A MessageID statement is required for each message,
// although the value is optional. If no value is specified, the value
// used is the previous value for the facility plus one. If the value
// is specified as +number then the value used is the previous value
// for the facility, plus the number after the plus sign. Otherwise, if
// a numeric value is given, that value is used. Any MessageId value
// that does not fit in 16 bits is an error.

// The Severity and Facility statements are optional. These statements
// specify additional bits to OR into the final 32-bit message code. If
// not specified they default to the value last specified for a message
// definition. The initial values prior to processing the first message
// definition are:

// Severity=Success
// Facility=App

// The value associated with Severity and Facility must match one of
// the names given in the FacilityNames and SeverityNames statements in
// the header section. The SymbolicName statement allows you to
// associate a C/C++ symbolic constant with the final 32-bit message
// code.


//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_SYSTEM                  0xFF
#define FACILITY_RUNTIME                 0xFFF


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: IDS_WRITENOTEQUAL
//
// MessageText:
//
//  Bytes actually written do not match bytes to write.
//
#define IDS_WRITENOTEQUAL                ((DWORD)0xEFFF0001L)

//
// MessageId: IDS_NOTVALIDOTPKEYFILE
//
// MessageText:
//
//  Selected file is not a valid One Time Pad Key File.
//
#define IDS_NOTVALIDOTPKEYFILE           ((DWORD)0xEFFF0002L)

//
// MessageId: IDS_CORRUPTSECRETKEYRING
//
// MessageText:
//
//  Malformed or corrupt Secret Key Ring.
//
#define IDS_CORRUPTSECRETKEYRING         ((DWORD)0xEFFF0003L)

//
// MessageId: IDS_CORRUPTPUBLICKEYRING
//
// MessageText:
//
//  Malformed or corrupt Public Key Ring.
//
#define IDS_CORRUPTPUBLICKEYRING         ((DWORD)0xEFFF0004L)

//
// MessageId: IDS_NOTAVALIDPUBLICKEYRING
//
// MessageText:
//
//  Selected file is not a valid Public Key Ring.
//
#define IDS_NOTAVALIDPUBLICKEYRING       ((DWORD)0xEFFF0005L)

//
// MessageId: IDS_NOTAVALIDSECRETKEYRING
//
// MessageText:
//
//  Selected file is not a valid Secret Key Ring.
//
#define IDS_NOTAVALIDSECRETKEYRING       ((DWORD)0xEFFF0006L)

//
// MessageId: IDS_PREMATUREEOF
//
// MessageText:
//
//  Premature end of file detected, possible file corruption.
//
#define IDS_PREMATUREEOF                 ((DWORD)0xEFFF0007L)

//
// MessageId: IDS_MISSINGKEYORINDEXFILE
//
// MessageText:
//
//  One or more Key Ring or Index Files are missing - the procedure is cancelled.
//
#define IDS_MISSINGKEYORINDEXFILE        ((DWORD)0xEFFF0008L)

//
// MessageId: IDS_UNKNOWNCTBBYTE
//
// MessageText:
//
//  Unknown Cipher Type Byte (CTB) in Key File - the procedure is cancelled.
//
#define IDS_UNKNOWNCTBBYTE               ((DWORD)0xEFFF0009L)

//
// MessageId: IDS_NOTPUBSECCTB
//
// MessageText:
//
//  Expected a Cipher Type Byte (CTB) for a Public or Secret Key - the procedure is cancelled.
//
#define IDS_NOTPUBSECCTB                 ((DWORD)0xEFFF000AL)

//
// MessageId: IDS_INVALIDLENGTHFIELDSIZE
//
// MessageText:
//
//  Invalid size of length field in key - the procedure is cancelled.
//
#define IDS_INVALIDLENGTHFIELDSIZE       ((DWORD)0xEFFF000BL)

//
// MessageId: IDS_PACKETSIZEEQUALSZERO
//
// MessageText:
//
//  Packet size of zero (0) encountered - the procedure is cancelled.
//
#define IDS_PACKETSIZEEQUALSZERO         ((DWORD)0xEFFF000CL)

//
// MessageId: IDS_KEYTOOLARGE
//
// MessageText:
//
//  Total length of key to add to the Key Ring is greater than 65,536 bytes - the procedure is cancelled.
//
#define IDS_KEYTOOLARGE                  ((DWORD)0xEFFF000DL)

//
// MessageId: IDS_KEYPACKETTOOLARGE
//
// MessageText:
//
//  Key packet size is too large - this key will not be added to the key ring.
//
#define IDS_KEYPACKETTOOLARGE            ((DWORD)0xEFFF000EL)

//
// MessageId: IDS_NOTVALIDKEYFILE
//
// MessageText:
//
//  Selected file is not a valid Key File to add to a Key Ring File.
//
#define IDS_NOTVALIDKEYFILE              ((DWORD)0xEFFF000FL)

//
// MessageId: IDS_NOSECRETTOPUBLIC
//
// MessageText:
//
//  Cannot add a Secret Key to a Public Key Ring - the procedure is cancelled.
//
#define IDS_NOSECRETTOPUBLIC             ((DWORD)0xEFFF0010L)

//
// MessageId: IDS_NOPUBLICTOSECRET
//
// MessageText:
//
//  Cannot add a Public Key to a Secret Key Ring - the procedure is cancelled.
//
#define IDS_NOPUBLICTOSECRET             ((DWORD)0xEFFF0011L)

//
// MessageId: IDS_UNSUPPORTEDVERSIONKEY
//
// MessageText:
//
//  Unsupported version encountered - skipping this key.
//
#define IDS_UNSUPPORTEDVERSIONKEY        ((DWORD)0xEFFF0012L)

//
// MessageId: IDS_NONRSAALGORITHMKEY
//
// MessageText:
//
//  Non RSA Algorithm in Key Encountered - skipping this key.
//
#define IDS_NONRSAALGORITHMKEY           ((DWORD)0xEFFF0013L)

//
// MessageId: IDS_MPIEQUALSZERO
//
// MessageText:
//
//  MPI length of zero (0) encountered - the procedure is cancelled.
//
#define IDS_MPIEQUALSZERO                ((DWORD)0xEFFF0014L)

//
// MessageId: IDS_MODULUSNTO0BIG
//
// MessageText:
//
//  Modulus n greater than 16,384 bits is not supported - skipping this key.
//
#define IDS_MODULUSNTO0BIG               ((DWORD)0xEFFF0015L)

//
// MessageId: IDS_MODULUSNTOOSMALL
//
// MessageText:
//
//  Modulus n less than 480 bits is not supported - skipping this key.
//
#define IDS_MODULUSNTOOSMALL             ((DWORD)0xEFFF0016L)

//
// MessageId: IDS_EXPONENTETOOBIG
//
// MessageText:
//
//  Exponent e greater than 64 bits is not supported - skipping this key.
//
#define IDS_EXPONENTETOOBIG              ((DWORD)0xEFFF0017L)

//
// MessageId: IDS_UNKNOWNALGORITHMFORSECRETCOMPONENTS
//
// MessageText:
//
//  Unknown algorithm used to hide the Secret Key components - skipping this key.
//
#define IDS_UNKNOWNALGORITHMFORSECRETCOMPONENTS ((DWORD)0xEFFF0018L)

//
// MessageId: IDS_MALFORMEDCORRUPTKEYFILE
//
// MessageText:
//
//  Malformed or corrupt Key File encountered - the procedure is cancelled.
//
#define IDS_MALFORMEDCORRUPTKEYFILE      ((DWORD)0xEFFF0019L)

//
// MessageId: IDS_USERIDTOOBIG
//
// MessageText:
//
//  User ID greater than 255 bytes encountered - skipping this key.
//
#define IDS_USERIDTOOBIG                 ((DWORD)0xEFFF001AL)

//
// MessageId: IDS_UNSUPPORTEDVERSIONSIG
//
// MessageText:
//
//  Unsupported version encountered - skipping this signature.
//
#define IDS_UNSUPPORTEDVERSIONSIG        ((DWORD)0xEFFF001BL)

//
// MessageId: IDS_FIRSTSIGNOTCOMPROMISE
//
// MessageText:
//
//  Signature immediately following a key packet is not a Compromise Certificate - skipping this key.
//
#define IDS_FIRSTSIGNOTCOMPROMISE        ((DWORD)0xEFFF001CL)

//
// MessageId: IDS_MORETHANONECOMPROMISE
//
// MessageText:
//
//  More than one Compromise Certificate in the key - skipping this key.
//
#define IDS_MORETHANONECOMPROMISE        ((DWORD)0xEFFF001DL)

//
// MessageId: IDS_COMPROMISEAFTERUSERID
//
// MessageText:
//
//  Compromise Certificate after User ID encountered - skipping this key.
//
#define IDS_COMPROMISEAFTERUSERID        ((DWORD)0xEFFF001EL)

//
// MessageId: IDS_UNKNOWNSIGNATURETYPE
//
// MessageText:
//
//  Unknown signature type following User ID - skipping this signature.
//
#define IDS_UNKNOWNSIGNATURETYPE         ((DWORD)0xEFFF001FL)

//
// MessageId: IDS_NONRSAALGORITHMSIG
//
// MessageText:
//
//  Non RSA Algorithm in Signature Encountered - skipping this signature.
//
#define IDS_NONRSAALGORITHMSIG           ((DWORD)0xEFFF0020L)

//
// MessageId: IDS_NONMD5ALGORITHMINSIG
//
// MessageText:
//
//  Non Md5 or Sha1 algorithm encountered in signature - skipping this signature.
//
#define IDS_NONMD5ALGORITHMINSIG         ((DWORD)0xEFFF0021L)

//
// MessageId: IDS_MALFORMEDCORRUPTKEYINSOURCE
//
// MessageText:
//
//  Malformed or corrupt key in source file - the procedure is cancelled.
//
#define IDS_MALFORMEDCORRUPTKEYINSOURCE  ((DWORD)0xEFFF0022L)

//
// MessageId: IDS_MATCHINGKEYIDSINDIFFERENTKEYS
//
// MessageText:
//
//  Matching Key IDs in two keys that are different - merging of these two keys is cancelled.
//
#define IDS_MATCHINGKEYIDSINDIFFERENTKEYS ((DWORD)0xEFFF0023L)

//
// MessageId: IDS_MALFORMEDCORRUPTKEYNOMERGE
//
// MessageText:
//
//  Malformed or corrupt key in source file - merging of these two keys is cancelled.
//
#define IDS_MALFORMEDCORRUPTKEYNOMERGE   ((DWORD)0xEFFF0024L)

//
// MessageId: IDS_FIRSTSIGNOTCOMPROMISENOMERGE
//
// MessageText:
//
//  Signature immediately following the key packet is not a Compromise Certificate - merging of these two keys is cancelled.
//
#define IDS_FIRSTSIGNOTCOMPROMISENOMERGE ((DWORD)0xEFFF0025L)

//
// MessageId: IDS_COMPSIGSNOMATCH
//
// MessageText:
//
//  Matching Keys With Different Compromise Certificates - merging of these two keys is cancelled.
//
#define IDS_COMPSIGSNOMATCH              ((DWORD)0xEFFF0026L)

//
// MessageId: IDS_EXPECETEDUSERIDINSECRETKEY
//
// MessageText:
//
//  Expected User ID in Secret Key - merging of these two keys is cancelled.
//
#define IDS_EXPECETEDUSERIDINSECRETKEY   ((DWORD)0xEFFF0027L)

//
// MessageId: IDS_USERIDTOBIGSKIP
//
// MessageText:
//
//  User ID greater than 255 bytes encountered - skipping this User ID.
//
#define IDS_USERIDTOBIGSKIP              ((DWORD)0xEFFF0028L)

//
// MessageId: IDS_USERIDREQUIRED
//
// MessageText:
//
//  User ID required in a Public or Secret Key - skipping this key.
//
#define IDS_USERIDREQUIRED               ((DWORD)0xEFFF0029L)

//
// MessageId: IDS_MATCHINGSIGSWITHDIFFERENTRSAINTEGERS
//
// MessageText:
//
//  Matching Signatures with different RSA integers - skipping this signature.
//
#define IDS_MATCHINGSIGSWITHDIFFERENTRSAINTEGERS ((DWORD)0xEFFF002AL)

//
// MessageId: IDS_WIPEVERIFYERROR
//
// MessageText:
//
//  Verification error occurred while wiping the file.
//
#define IDS_WIPEVERIFYERROR              ((DWORD)0xEFFF002BL)

//
// MessageId: IDS_INSUFFICIENTSPACE
//
// MessageText:
//
//  Insufficient space on selected destination to write files to. Select a different destination.
//
#define IDS_INSUFFICIENTSPACE            ((DWORD)0xEFFF002CL)

//
// MessageId: IDS_INVALIDDRIVETYPE
//
// MessageText:
//
//  Selected destination is not a valid drive type. Select a valid drive.
//
#define IDS_INVALIDDRIVETYPE             ((DWORD)0xEFFF002DL)

//
// MessageId: IDS_NOSPACE
//
// MessageText:
//
//  No space on selected destination. You may not be able to write to this drive. Select another destination.
//
#define IDS_NOSPACE                      ((DWORD)0xEFFF002EL)

//
// MessageId: IDS_RAMDRIVE
//
// MessageText:
//
//  A RAM drive is not a valid selection for this operation. Select a valid drive.
//
#define IDS_RAMDRIVE                     ((DWORD)0xEFFF002FL)

//
// MessageId: IDS_NOROOMFORBASENAME
//
// MessageText:
//
//  Destination folder minus the OTP Key File suffix leaves no room for a base name. Select a shorter folder name.
//
#define IDS_NOROOMFORBASENAME            ((DWORD)0xEFFF0030L)

//
// MessageId: IDS_PATHTOOLONG
//
// MessageText:
//
//  Length of destination folder and file name exceeds 260 characters. Select a shorter folder name as your destination.
//
#define IDS_PATHTOOLONG                  ((DWORD)0xEFFF0031L)

//
// MessageId: IDS_NORECIPIENTS
//
// MessageText:
//
//  All of the selected recipient's keys are disabled. Encrypting of this file is cancelled.
//
#define IDS_NORECIPIENTS                 ((DWORD)0xEFFF0032L)

//
// MessageId: IDS_MD5FAILURE
//
// MessageText:
//
//  A check of the Top Secret Crypto Gold Exe File has determined that it has been altered, perhaps by tampering or a virus. Program execution is terminated.
//
#define IDS_MD5FAILURE                   ((DWORD)0xEFFF0033L)

//
// MessageId: IDS_CANNOTDETERMINEIFSECRETKEYDISABLED
//
// MessageText:
//
//  Cannot determine if the selected Secret Key to sign the file with is disabled or not. Encrypting of this file is cancelled.
//
#define IDS_CANNOTDETERMINEIFSECRETKEYDISABLED ((DWORD)0xEFFF0034L)

//
// MessageId: IDS_SELECTEDSECRETKEYISDISABLED
//
// MessageText:
//
//  The selected Secret Key to sign the file with is disabled. Encrypting of this file is cancelled.
//
#define IDS_SELECTEDSECRETKEYISDISABLED  ((DWORD)0xEFFF0035L)

//
// MessageId: IDS_NOTVALIDTSCFILE
//
// MessageText:
//
//  The selected file is not a valid Top Secret Crypto Gold encrypted file. Select a valid Top Secret Crypto Gold encrypted file.
//
#define IDS_NOTVALIDTSCFILE              ((DWORD)0xEFFF0036L)

//
// MessageId: IDS_RSAINTEGERGTEMODULUSN
//
// MessageText:
//
//  The RSA integer in the Public Key Encrypted Packet is greater than or equal to Modulus n in the Secret Key. Possible corruption or tampering. Deciphering is cancelled.
//
#define IDS_RSAINTEGERGTEMODULUSN        ((DWORD)0xEFFF0037L)

//
// MessageId: IDS_RSAPRIVATEDECRYPTERROR
//
// MessageText:
//
//  Error encountered while decrypting our Public Key Encrypted Packet. We cannot decipher this file.
//
#define IDS_RSAPRIVATEDECRYPTERROR       ((DWORD)0xEFFF0038L)

//
// MessageId: IDS_DEBUGGERPRESENT
//
// MessageText:
//
//  Top Secret Crypto Gold has detected that a debugger has been attached to the program. Top Secret Crypto Gold is hereby terminated.
//
#define IDS_DEBUGGERPRESENT              ((DWORD)0xEFFF0039L)

//
// MessageId: IDS_INVALIDKEYLENGTH
//
// MessageText:
//
//  Invalid decrypted Public Key Encrypted Packet data length. We cannot decipher this file.
//
#define IDS_INVALIDKEYLENGTH             ((DWORD)0xEFFF003AL)

//
// MessageId: IDS_PKECSUMINVALID
//
// MessageText:
//
//  Checksum of the decrypted Session Key in the Public Key Encrypted Packet is invalid. We cannot decipher this file.
//
#define IDS_PKECSUMINVALID               ((DWORD)0xEFFF003BL)

//
// MessageId: IDS_SKEOUTOFORDER
//
// MessageText:
//
//  Packets in this file are out of order. Expected a Secret Key Encrypted Packet. Deciphering of this file is cancelled.
//
#define IDS_SKEOUTOFORDER                ((DWORD)0xEFFF003CL)

//
// MessageId: IDS_FIPOUTOFORDER
//
// MessageText:
//
//  Packets in this file are out of order. Expected a File Information Packet. Deciphering of this file is cancelled.
//
#define IDS_FIPOUTOFORDER                ((DWORD)0xEFFF003DL)

//
// MessageId: IDS_CKEOUTOFORDER
//
// MessageText:
//
//  Packets in this file are out of order. Expected a Conventional Key Encrypted Data Packet. Deciphering of this file is cancelled.
//
#define IDS_CKEOUTOFORDER                ((DWORD)0xEFFF003EL)

//
// MessageId: IDS_FIPINVALIDLENGTH
//
// MessageText:
//
//  Invalid length for File Information Packet. Deciphering of this file is cancelled.
//
#define IDS_FIPINVALIDLENGTH             ((DWORD)0xEFFF003FL)

//
// MessageId: IDS_WRONGOTPKEYFILE
//
// MessageText:
//
//  You have selected the wrong One Time Pad Key File. Select the designated file, or select Cancel to cancel.
//
#define IDS_WRONGOTPKEYFILE              ((DWORD)0xEFFF0040L)

//
// MessageId: IDS_PATHTOOLONGDEC
//
// MessageText:
//
//  Destination plus name of decrypted file exceeds the maximum length of 260 characters. Select a shorter destination. Deciphering of this file is cancelled.
//
#define IDS_PATHTOOLONGDEC               ((DWORD)0xEFFF0041L)

//
// MessageId: IDS_DECRYPTEDNOTEQUAL
//
// MessageText:
//
//  For Information Only: The actual number of bytes decrypted does not equal the number stored in the header. Possible corrupted data or tampering.
//
#define IDS_DECRYPTEDNOTEQUAL            ((DWORD)0xEFFF0042L)

//
// MessageId: IDS_INVALIDSKEPACKET
//
// MessageText:
//
//  The Secret Key Encrypted Packet (Signature Packet) is invalid. Possible data corruption, tampering, or unsupported signature type. We cannot verify the integrity of the decrypted file.
//
#define IDS_INVALIDSKEPACKET             ((DWORD)0xEFFF0043L)

//
// MessageId: IDS_SKEINTEGERTOOBIG
//
// MessageText:
//
//  The RSA encrypted integer in the Secret Key Encrypted Packet (Signature Packet) is greater than 16,384 bits. We cannot verify the integrity of the decrypted file.
//
#define IDS_SKEINTEGERTOOBIG             ((DWORD)0xEFFF0044L)

//
// MessageId: IDS_NOPUBLICKEYTODECRYPTSKE
//
// MessageText:
//
//  We do not possess the Public Key required to decrypt the Secret Key Encrypted Packet (Signature Packet). We cannot verify the integrity of the decrypted file.%n%nKey ID: %X           Signature Size: %u Bits
//
#define IDS_NOPUBLICKEYTODECRYPTSKE      ((DWORD)0xEFFF0045L)

//
// MessageId: IDS_RSAINTEGERINSKEGTMODNINPUBKEY
//
// MessageText:
//
//  The RSA encrypted integer in the Secret Key Encrypted Packet (Signature Packet) is greater than Modulus n in the Public Key. We cannot verify the integrity of the decrypted or signed file.
//
#define IDS_RSAINTEGERINSKEGTMODNINPUBKEY ((DWORD)0xEFFF0046L)

//
// MessageId: IDS_RSAPUBDECFAILED
//
// MessageText:
//
//  Decryption of the RSA encrypted integer in the Secret Key Encrypted Packet (Signature Packet) failed. We cannot verify the integrity of the decrypted or signed file.
//
#define IDS_RSAPUBDECFAILED              ((DWORD)0xEFFF0047L)

//
// MessageId: IDS_TSCTOOLARGE
//
// MessageText:
//
//  The Phi and Chi Test Procedures can only handle files that are 4,294,967,295 bytes or less in size. The procedure is cancelled.
//
#define IDS_TSCTOOLARGE                  ((DWORD)0xEFFF0048L)

//
// MessageId: IDS_CKEHDRERROR
//
// MessageText:
//
//  Computed size of data to read from the file does not match the actual number of bytes read. Possible file corruption or tampering.
//
#define IDS_CKEHDRERROR                  ((DWORD)0xEFFF0049L)

//
// MessageId: IDS_NODEFAULTVALUE
//
// MessageText:
//
//  Top Secret Crypto Gold has determined that it has not been installed with the supplied installation program. Many required registry entries will be missing. Please install Top Secret Crypto Gold with the installation program.
//
#define IDS_NODEFAULTVALUE               ((DWORD)0xEFFF004AL)

//
// MessageId: IDS_XFORMTOOBIG
//
// MessageText:
//
//  Selected file for e-mail transformation will create more than the maximum of 999 smaller files. Select a smaller file to transform for e-mail transmission.
//
#define IDS_XFORMTOOBIG                  ((DWORD)0xEFFF004BL)

//
// MessageId: IDS_NOTRANSFORMROOM
//
// MessageText:
//
//  Insufficient space on selected drive to hold all of the transformed files. Select another drive with more space available.
//
#define IDS_NOTRANSFORMROOM              ((DWORD)0xEFFF004CL)

//
// MessageId: IDS_PATHTOOLONGEXTRACT
//
// MessageText:
//
//  Destination plus name of transformed file exceeds the maximum length of 260 characters. Select a shorter destination. Extraction of transformed files is cancelled.
//
#define IDS_PATHTOOLONGEXTRACT           ((DWORD)0xEFFF004DL)

//
// MessageId: IDS_ENDOFFILEBEFOREENDID
//
// MessageText:
//
//  End of file reached before we found the end ID for a transformed file. File may be corrupted or tampered with.
//
#define IDS_ENDOFFILEBEFOREENDID         ((DWORD)0xEFFF004EL)

//
// MessageId: IDS_EOFBEFORESTARTHEADER
//
// MessageText:
//
//  End of file reached before we found the start ID for a transformed file. File may be corrupted or tampered with.
//
#define IDS_EOFBEFORESTARTHEADER         ((DWORD)0xEFFF004FL)

//
// MessageId: IDS_INVALIDEMAILFILE
//
// MessageText:
//
//  Selected file is not a valid transformed file. Select a valid transformed file.
//
#define IDS_INVALIDEMAILFILE             ((DWORD)0xEFFF0050L)

//
// MessageId: IDS_NORECONSTRUCTROOM
//
// MessageText:
//
//  Insufficient space on selected drive to hold the reconstructed file. Select another drive with more space.
//
#define IDS_NORECONSTRUCTROOM            ((DWORD)0xEFFF0051L)

//
// MessageId: IDS_PATHTOBIGRECON
//
// MessageText:
//
//  Length of destination plus name of reconstructed file exceeds the maximum of 260 characters. Select a shorter destination for the reconstructed file.
//
#define IDS_PATHTOBIGRECON               ((DWORD)0xEFFF0052L)

//
// MessageId: IDS_EOFBEFOREENDOFRECON
//
// MessageText:
//
//  End of file reached before end of reconstruction for this file. Possible file corruption or tampering.
//
#define IDS_EOFBEFOREENDOFRECON          ((DWORD)0xEFFF0053L)

//
// MessageId: IDS_RECONCRCFAILED
//
// MessageText:
//
//  Reconstruction integrity check failed on this file. Possible file corruption or tampering. Reconstruction will continue for the rest of the files.
//
#define IDS_RECONCRCFAILED               ((DWORD)0xEFFF0054L)

//
// MessageId: IDS_NOFILESPACKED
//
// MessageText:
//
//  All files selected to pack were zero length files.
//
#define IDS_NOFILESPACKED                ((DWORD)0xEFFF0055L)

//
// MessageId: IDS_INVALIDPACKEDFILE
//
// MessageText:
//
//  Selected file is not a valid packed file. Select a valid packed file or select Cancel to exit.
//
#define IDS_INVALIDPACKEDFILE            ((DWORD)0xEFFF0056L)

//
// MessageId: IDS_BADHEADERCRC32
//
// MessageText:
//
//  Packed file header CRC 32 check value is invalid. Possible file corruption. Unpacking of this file is cancelled.
//
#define IDS_BADHEADERCRC32               ((DWORD)0xEFFF0057L)

//
// MessageId: IDS_PATHTOOLONGUNPACK
//
// MessageText:
//
//  Destination plus length of file name to unpack exceeds the maximum length of 260 characters. This file will not be unpacked.
//
#define IDS_PATHTOOLONGUNPACK            ((DWORD)0xEFFF0058L)

//
// MessageId: IDS_NOTENOUGHMEMORYTOUNPACK
//
// MessageText:
//
//  Insufficient memory to unpack this file. The file will not be unpacked.
//
#define IDS_NOTENOUGHMEMORYTOUNPACK      ((DWORD)0xEFFF0059L)

//
// MessageId: IDS_DECOMPINTEGRITYFAILED
//
// MessageText:
//
//  CRC 32 integrity check on unpacked file failed. Possible file corruption.
//
#define IDS_DECOMPINTEGRITYFAILED        ((DWORD)0xEFFF005AL)

//
// MessageId: IDS_NOTENOUGHMEMORYTOTEST
//
// MessageText:
//
//  Insufficient memory to test this file. The file cannot be tested.
//
#define IDS_NOTENOUGHMEMORYTOTEST        ((DWORD)0xEFFF005BL)

//
// MessageId: IDS_TESTINTEGRITYFAILED
//
// MessageText:
//
//  CRC 32 test integrity check on packed file failed. Possible file corruption.
//
#define IDS_TESTINTEGRITYFAILED          ((DWORD)0xEFFF005CL)

//
// MessageId: IDS_NOSPACEFRESHEN
//
// MessageText:
//
//  The selected packed file to freshen, or add files to, is on a disk with zero bytes free. The disk is full, or may be a CD ROM disk you cannot write to.
//
#define IDS_NOSPACEFRESHEN               ((DWORD)0xEFFF005DL)

//
// MessageId: IDS_PATHTOOLONGFRESHEN
//
// MessageText:
//
//  Length of source folder and file name to freshen exceeds 260 characters. This file will not be checked to see if it needs to be freshened.
//
#define IDS_PATHTOOLONGFRESHEN           ((DWORD)0xEFFF005EL)

//
// MessageId: IDS_NOFILESTOFRESHEN
//
// MessageText:
//
//  There are no files to freshen in the packed file from the selected folder.
//
#define IDS_NOFILESTOFRESHEN             ((DWORD)0xEFFF005FL)

//
// MessageId: IDS_NONEWFILESTOADD
//
// MessageText:
//
//  There are no new files in the selected list to add to the packed file.
//
#define IDS_NONEWFILESTOADD              ((DWORD)0xEFFF0060L)

//
// MessageId: IDS_ENCIPHERLENGTHOFZERO
//
// MessageText:
//
//  The selected file to encipher is a zero length file. Select another file to encipher, or select cancel to exit.
//
#define IDS_ENCIPHERLENGTHOFZERO         ((DWORD)0xEFFF0061L)

//
// MessageId: IDS_BYTESREADNOTEQUALTOREQUEST
//
// MessageText:
//
//  Bytes actually read does not equal the requested number of bytes. Possible file corruption. Procedure cancelled.
//
#define IDS_BYTESREADNOTEQUALTOREQUEST   ((DWORD)0xEFFF0062L)

//
// MessageId: IDS_ALREADYEXISTS
//
// MessageText:
//
//  File name entered already exists in the selected folder. Enter a different file name, select a different folder, or select Cancel to exit.
//
#define IDS_ALREADYEXISTS                ((DWORD)0xEFFF0063L)

//
// MessageId: IDS_NOTENOUGHMEMORYTOPACKWITH
//
// MessageText:
//
//  Insufficient memory to pack any of the files with. The procedure is cancelled.
//
#define IDS_NOTENOUGHMEMORYTOPACKWITH    ((DWORD)0xEFFF0064L)

//
// MessageId: IDS_NOTVALIDTRUEPADFILE
//
// MessageText:
//
//  Selected file is not a valid True One Time Pad File.
//
#define IDS_NOTVALIDTRUEPADFILE          ((DWORD)0xEFFF0065L)

//
// MessageId: IDS_PADBYTESNOTENOUGH
//
// MessageText:
//
//  Insufficient random bytes in selected pad file to encrypt your file with. Select another pad file or select Cancel to exit.
//
#define IDS_PADBYTESNOTENOUGH            ((DWORD)0xEFFF0066L)

//
// MessageId: IDS_UNABLE_TO_SET_START_POINT
//
// MessageText:
//
//  Unable to set a new starting point in the header of the pad file after encryption was completed. This pad file should no longer be used.
//
#define IDS_UNABLE_TO_SET_START_POINT    ((DWORD)0xEFFF0067L)

//
// MessageId: IDS_WRONGTRUEONETIMEPADFILE
//
// MessageText:
//
//  You have selected the wrong True One Time Pad File. Select the designated file, or select Cancel to cancel.
//
#define IDS_WRONGTRUEONETIMEPADFILE      ((DWORD)0xEFFF0068L)

//
// MessageId: IDS_PADOVERWRITEERROR
//
// MessageText:
//
//  An error occurred while wiping the section of a True One Time Pad File you just used. Your True One Time Pad File may be corrupted and unusable.
//
#define IDS_PADOVERWRITEERROR            ((DWORD)0xEFFF0069L)

//
// MessageId: IDS_NOTEXTFORMAT
//
// MessageText:
//
//  Required Clipboard Text Format to import a Public Key or decrypt an Encrypted Message is not available.
//
#define IDS_NOTEXTFORMAT                 ((DWORD)0xEFFF006AL)

//
// MessageId: IDS_NOPUBLICKEYINCLIP
//
// MessageText:
//
//  The contents of the Clipboard is not a complete or valid Public or Secret Key. The procedure is cancelled.
//
#define IDS_NOPUBLICKEYINCLIP            ((DWORD)0xEFFF006BL)

//
// MessageId: IDS_NOVALIDCRC24
//
// MessageText:
//
//  Invalid character encountered in the armored buffer holding the Public or Secret Key or Encrypted Message. The procedure is cancelled.
//
#define IDS_NOVALIDCRC24                 ((DWORD)0xEFFF006CL)

//
// MessageId: IDS_CRC24NOMATCH
//
// MessageText:
//
//  Calculated and stored crc24 value do not match. Cannot validate the Public or Secret Key or Encrypted Message. The procedure is cancelled.
//
#define IDS_CRC24NOMATCH                 ((DWORD)0xEFFF006DL)

//
// MessageId: IDS_NOVALIDFORMATS
//
// MessageText:
//
//  There are no formats in the clipboard that Top Secret Crypto Gold can handle for encrypting the clipboard.
//
#define IDS_NOVALIDFORMATS               ((DWORD)0xEFFF006EL)

//
// MessageId: IDS_NOENCRYPTEMSG
//
// MessageText:
//
//  The contents of the message is not a complete or valid Top Secret Crypto Gold encrypted message. The procedure is cancelled.
//
#define IDS_NOENCRYPTEMSG                ((DWORD)0xEFFF006FL)

//
// MessageId: IDS_MAPINOKEY
//
// MessageText:
//
//  The registry key "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Messaging Subsystem" was not found. Cannot determine if your system uses the MAPI e-mail protocol. See the Help Topic About Simple MAPI for complete details.
//
#define IDS_MAPINOKEY                    ((DWORD)0xEFFF0070L)

//
// MessageId: IDS_M_ABORT
//
// MessageText:
//
//  The user canceled one of the dialog boxes. No message was sent.
//
#define IDS_M_ABORT                      ((DWORD)0xEFFF0071L)

//
// MessageId: IDS_M_FAILURE
//
// MessageText:
//
//  One or more unspecified errors occurred.
//
#define IDS_M_FAILURE                    ((DWORD)0xEFFF0072L)

//
// MessageId: IDS_M_LOGIN_FAIL
//
// MessageText:
//
//  There was no default logon, and the user failed to log on successfully when the logon dialog box was displayed.
//
#define IDS_M_LOGIN_FAIL                 ((DWORD)0xEFFF0073L)

//
// MessageId: IDS_M_DISK_FULL
//
// MessageText:
//
//  Disk is full. Operation could not proceed.
//
#define IDS_M_DISK_FULL                  ((DWORD)0xEFFF0074L)

//
// MessageId: IDS_M_NO_MEMORY
//
// MessageText:
//
//  There was insufficient memory to proceed.
//
#define IDS_M_NO_MEMORY                  ((DWORD)0xEFFF0075L)

//
// MessageId: IDS_M_NO_ACCESS
//
// MessageText:
//
//  Access Denied. Operation could not proceed.
//
#define IDS_M_NO_ACCESS                  ((DWORD)0xEFFF0076L)

//
// MessageId: IDS_M_TOO_SESSIONS
//
// MessageText:
//
//  The user had too many sessions open simultaneously. No session handle was returned.
//
#define IDS_M_TOO_SESSIONS               ((DWORD)0xEFFF0077L)

//
// MessageId: IDS_M_UNKNOWN
//
// MessageText:
//
//  Unknown MAPI Error.
//
#define IDS_M_UNKNOWN                    ((DWORD)0xEFFF0078L)

//
// MessageId: IDS_M_TOO_FILES
//
// MessageText:
//
//  There were too many file attachments. No message was sent.
//
#define IDS_M_TOO_FILES                  ((DWORD)0xEFFF0079L)

//
// MessageId: IDS_M_TOO_RECIPS
//
// MessageText:
//
//  There were too many recipients. No message was sent.
//
#define IDS_M_TOO_RECIPS                 ((DWORD)0xEFFF007AL)

//
// MessageId: IDS_M_ATACH_N_FOUND
//
// MessageText:
//
//  The specified attachment was not found. No message was sent.
//
#define IDS_M_ATACH_N_FOUND              ((DWORD)0xEFFF007BL)

//
// MessageId: IDS_M_ATACH_N_OPEN
//
// MessageText:
//
//  The specified attachment could not be opened. No message was sent.
//
#define IDS_M_ATACH_N_OPEN               ((DWORD)0xEFFF007CL)

//
// MessageId: IDS_M_ATTCH_N_WRITE
//
// MessageText:
//
//  An attachment could not be written to a temporary file. Check directory permissions.
//
#define IDS_M_ATTCH_N_WRITE              ((DWORD)0xEFFF007DL)

//
// MessageId: IDS_M_UNKN_RECIP
//
// MessageText:
//
//  The recipient could not be resolved to any address. The recipient might not exist or might be unknown.
//
#define IDS_M_UNKN_RECIP                 ((DWORD)0xEFFF007EL)

//
// MessageId: IDS_M_BAD_RECIPTYPE
//
// MessageText:
//
//  The type of a recipient was not MAPI_TO, MAPI_CC, or MAPI_BCC. No message was sent.
//
#define IDS_M_BAD_RECIPTYPE              ((DWORD)0xEFFF007FL)

//
// MessageId: IDS_M_NO_MESSAGES
//
// MessageText:
//
//  A matching message could not be found.
//
#define IDS_M_NO_MESSAGES                ((DWORD)0xEFFF0080L)

//
// MessageId: IDS_M_INVALID_MSG
//
// MessageText:
//
//  An invalid message identifier was passed in the Seed Message ID parameter. No message was found.
//
#define IDS_M_INVALID_MSG                ((DWORD)0xEFFF0081L)

//
// MessageId: IDS_M_TEXT_TOO_LRG
//
// MessageText:
//
//  The text in the message was too large. No message was sent.
//
#define IDS_M_TEXT_TOO_LRG               ((DWORD)0xEFFF0082L)

//
// MessageId: IDS_M_INVALID_SESS
//
// MessageText:
//
//  An invalid session handle was used for the e-mail session parameter.
//
#define IDS_M_INVALID_SESS               ((DWORD)0xEFFF0083L)

//
// MessageId: IDS_M_TYPE_N_SUPP
//
// MessageText:
//
//  Type not supported. Operation could not proceed.
//
#define IDS_M_TYPE_N_SUPP                ((DWORD)0xEFFF0084L)

//
// MessageId: IDS_M_AMBIG_RECIP
//
// MessageText:
//
//  The recipient requested has not been or could not be resolved to a unique address list entry.
//
#define IDS_M_AMBIG_RECIP                ((DWORD)0xEFFF0085L)

//
// MessageId: IDS_M_MSG_IN_USE
//
// MessageText:
//
//  Message is already in use. Operation could not proceed.
//
#define IDS_M_MSG_IN_USE                 ((DWORD)0xEFFF0086L)

//
// MessageId: IDS_M_NETWRK_FAIL
//
// MessageText:
//
//  Network failure. Operation could not proceed.
//
#define IDS_M_NETWRK_FAIL                ((DWORD)0xEFFF0087L)

//
// MessageId: IDS_M_INVALID_EDFLD
//
// MessageText:
//
//  Invalid edit field. Operation could not proceed.
//
#define IDS_M_INVALID_EDFLD              ((DWORD)0xEFFF0088L)

//
// MessageId: IDS_M_INVALID_RECIP
//
// MessageText:
//
//  One or more recipients were invalid or did not resolve to any address.
//
#define IDS_M_INVALID_RECIP              ((DWORD)0xEFFF0089L)

//
// MessageId: IDS_M_NOT_SUPPORTED
//
// MessageText:
//
//  The operation was not supported by the underlying messaging system.
//
#define IDS_M_NOT_SUPPORTED              ((DWORD)0xEFFF008AL)

//
// MessageId: IDS_M_PATHTOOLONG
//
// MessageText:
//
//  Length of destination folder and file name exceeds 260 characters. This file attachment will not be saved.
//
#define IDS_M_PATHTOOLONG                ((DWORD)0xEFFF008BL)

//
// MessageId: IDS_DEARMORBUFFERERROR
//
// MessageText:
//
//  Invalid character in the radix-64 text buffer for a Public or Secret Key, Signature, or Encrypted Message. The Procedure is cancelled.
//
#define IDS_DEARMORBUFFERERROR           ((DWORD)0xEFFF008CL)

//
// MessageId: IDS_RTFSTREAMINERROR
//
// MessageText:
//
//  An error occurred while trying to stream a file into the Rich Text Edit Control. May be insufficient memory in the Rich Text Edit Control to handle the operation.
//
#define IDS_RTFSTREAMINERROR             ((DWORD)0xEFFF008DL)

//
// MessageId: IDS_RTFSTREAMOUTERROR
//
// MessageText:
//
//  An error occurred while trying to stream a file out of the Rich Text Edit Control.
//
#define IDS_RTFSTREAMOUTERROR            ((DWORD)0xEFFF008EL)

//
// MessageId: IDS_MAPIMISSING
//
// MessageText:
//
//  The value label MAPI under registry key "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Messaging Subsystem" was not found. Cannot determine if your system uses the MAPI e-mail protocol. See the Help Topic About Simple MAPI for complete details.
//
#define IDS_MAPIMISSING                  ((DWORD)0xEFFF008FL)

//
// MessageId: IDS_MAPINE1
//
// MessageText:
//
//  The value for MAPI under registry key "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Messaging Subsystem" is not equal to 1. Your system is not using the MAPI e-mail protocol. See the Help Topic About Simple MAPI for complete details.
//
#define IDS_MAPINE1                      ((DWORD)0xEFFF0090L)

//
// MessageId: IDS_NOMAPI32DLL
//
// MessageText:
//
//  Top Secret Crypto Gold could not find mapi32.dll on your system which is required to use the e-mail procedure. The e-mail procedures will not be available to you.
//
#define IDS_NOMAPI32DLL                  ((DWORD)0xEFFF0091L)

//
// MessageId: IDS_MAPIPROCADDRESSERROR
//
// MessageText:
//
//  An error occurred when Top Secret Crypto Gold tried to retrieve procedure addresses from mapi32.dll that are required for the e-mail procedures. The e-mail procedures will not be available to you.
//
#define IDS_MAPIPROCADDRESSERROR         ((DWORD)0xEFFF0092L)

//
// MessageId: IDS_MD5BYPASS
//
// MessageText:
//
//  Top Secret Crypto Gold has determined that internal security checks have been bypassed. The program is terminated.
//
#define IDS_MD5BYPASS                    ((DWORD)0xEFFF0093L)

//
// MessageId: IDS_TOTALEQUALSZERO
//
// MessageText:
//
//  The total size of all the files selected to pack is zero. The procedure is cancelled.
//
#define IDS_TOTALEQUALSZERO              ((DWORD)0xEFFF0094L)

//
// MessageId: IDS_ADMINKEYMISSING
//
// MessageText:
//
//  Administrator or password registry key is missing. Please reinstall Top Secret Crypto Gold.
//
#define IDS_ADMINKEYMISSING              ((DWORD)0xEFFF0095L)

//
// MessageId: IDS_Z_MEM_ERROR
//
// MessageText:
//
//  Insufficient memory for the zlib library to compress or decompress a file.
//
#define IDS_Z_MEM_ERROR                  ((DWORD)0xEFFF0096L)

//
// MessageId: IDS_Z_DATA_ERROR
//
// MessageText:
//
//  A data error occurred in the compression output or decompression input stream. The procedure is cancelled.
//
#define IDS_Z_DATA_ERROR                 ((DWORD)0xEFFF0097L)

//
// MessageId: IDS_Z_BUFF_ERROR
//
// MessageText:
//
//  A buffer error occurred during compression or decompression. The procedure is cancelled.
//
#define IDS_Z_BUFF_ERROR                 ((DWORD)0xEFFF0098L)

//
// MessageId: IDS_Z_STREAM_ERROR
//
// MessageText:
//
//  A stream error occurred during compression or decompression. The procedure is cancelled.
//
#define IDS_Z_STREAM_ERROR               ((DWORD)0xEFFF0099L)

//
// MessageId: IDS_Z_UNKNOWN
//
// MessageText:
//
//  An unknown error occurred during compression or decompression. The procedure is cancelled.
//
#define IDS_Z_UNKNOWN                    ((DWORD)0xEFFF009AL)

//
// MessageId: IDS_EMAILCRCNOGOOD
//
// MessageText:
//
//  The Crc32 check value for the decompressed e-mail message is invalid. Possible data corruption. The procedure is cancelled.
//
#define IDS_EMAILCRCNOGOOD               ((DWORD)0xEFFF009BL)

//
// MessageId: IDS_NODELCURRENTDIR
//
// MessageText:
//
//  You are trying to remove the currently designated active directory, which is not allowed. Exit the program and run it again to try to remove it.
//
#define IDS_NODELCURRENTDIR              ((DWORD)0xEFFF009CL)

//
// MessageId: IDS_SAMPLESIZETOOSMALL
//
// MessageText:
//
//  Remaining valid data in the True One Time Pad File is less than 8K which is too small to conduct a meaningful Phi Test on. The procedure is cancelled.
//
#define IDS_SAMPLESIZETOOSMALL           ((DWORD)0xEFFF009DL)

//
// MessageId: IDS_DONOTSUPPORTV4SIGS
//
// MessageText:
//
//  PGP version 4 signatures are not supported. Skipping this signature.
//
#define IDS_DONOTSUPPORTV4SIGS           ((DWORD)0xEFFF009EL)

//
// MessageId: IDS_DONOTSUPPORTNEWVERSIONFORMAT
//
// MessageText:
//
//  PGP and OpenPGP new format keys not supported. Skipping this key.
//
#define IDS_DONOTSUPPORTNEWVERSIONFORMAT ((DWORD)0xEFFF009FL)

//
// MessageId: IDS_SIGNAMEPLUSEXTTOOLONG
//
// MessageText:
//
//  Adding the Signature File Extension of .tsig to the path and file name creates a file specification in excess of 260 bytes. Rename the file or copy it to a shorter path and try again.
//
#define IDS_SIGNAMEPLUSEXTTOOLONG        ((DWORD)0xEFFF00A0L)

//
// MessageId: IDS_SIGFILEINVALID
//
// MessageText:
//
//  Selected Signature File is not a valid signature file. It has incorrect headers or is too large to be a signature file.
//
#define IDS_SIGFILEINVALID               ((DWORD)0xEFFF00A1L)

//
// MessageId: IDS_DONOTSUPPORTNEWSIGFORMAT
//
// MessageText:
//
//  PGP and OpenPGP new format and version 4 format signatures not supported. Procedure is cancelled.
//
#define IDS_DONOTSUPPORTNEWSIGFORMAT     ((DWORD)0xEFFF00A2L)

//
// MessageId: IDS_UNKNOWNSIGVERSION
//
// MessageText:
//
//  Unknown signature version encountered. Procedure cancelled.
//
#define IDS_UNKNOWNSIGVERSION            ((DWORD)0xEFFF00A3L)

//
// MessageId: IDS_INVALIDSIGPACKET
//
// MessageText:
//
//  Invalid fields or unknown algorithm values in signature packet. Procedure cancelled.
//
#define IDS_INVALIDSIGPACKET             ((DWORD)0xEFFF00A4L)

//
// MessageId: IDS_SIGINTEGERTOOBIG
//
// MessageText:
//
//  The Secret Key Encrypted Packet (Signature Packet) is larger than Top Secret Crypto Gold can handle. We cannot process this signature file. Procedure cancelled.
//
#define IDS_SIGINTEGERTOOBIG             ((DWORD)0xEFFF00A5L)

//
// MessageId: IDS_NOPUBLICKEYTODECRYPTSIG
//
// MessageText:
//
//  We do not possess the Public Key required to decrypt the Secret Key Encrypted Packet (Signature Packet). We cannot verify the integrity of the signed file.%n%nKey ID: %X           Signature Size: %u Bits
//
#define IDS_NOPUBLICKEYTODECRYPTSIG      ((DWORD)0xEFFF00A6L)

//
// MessageId: IDS_SIGCHECKFILEERROR
//
// MessageText:
//
//  An error occurred while conducting the Md5 or Sha1 test. Cannot verify the detached signature for this file.
//
#define IDS_SIGCHECKFILEERROR            ((DWORD)0xEFFF00A7L)

//
// MessageId: IDS_SSCE_BAD_SESSION_ID_ERR
//
// MessageText:
//
//  The session id does not correspond to an open session.
//
#define IDS_SSCE_BAD_SESSION_ID_ERR      ((DWORD)0xEFFF00A8L)

//
// MessageId: IDS_SSCE_WORD_NOT_FOUND_ERR
//
// MessageText:
//
//  The word specified in a parameter does not exist, or a block or string cursor has reached the end of the text.
//
#define IDS_SSCE_WORD_NOT_FOUND_ERR      ((DWORD)0xEFFF00A9L)

//
// MessageId: IDS_SSCE_FILE_NOT_FOUND_ERR
//
// MessageText:
//
//  The file specified in a parameter does not exist.
//
#define IDS_SSCE_FILE_NOT_FOUND_ERR      ((DWORD)0xEFFF00AAL)

//
// MessageId: IDS_SSCE_TOO_MANY_LEXICONS_ERR
//
// MessageText:
//
//  The limit on the number of open lexicons in a session has been reached.
//
#define IDS_SSCE_TOO_MANY_LEXICONS_ERR   ((DWORD)0xEFFF00ABL)

//
// MessageId: IDS_SSCE_UNKNOWN_ACTION_ERR
//
// MessageText:
//
//  The action code is unrecognizable. Unknown error.
//
#define IDS_SSCE_UNKNOWN_ACTION_ERR      ((DWORD)0xEFFF00ACL)

//
// MessageId: IDS_SSCE_BAD_LEXICON_ID_ERR
//
// MessageText:
//
//  The lexicon id does not correspond to an open lexicon.
//
#define IDS_SSCE_BAD_LEXICON_ID_ERR      ((DWORD)0xEFFF00ADL)

//
// MessageId: IDS_SSCE_BUFFER_TOO_SMALL_ERR
//
// MessageText:
//
//  The specified buffer is not large enough to hold the requested information.
//
#define IDS_SSCE_BUFFER_TOO_SMALL_ERR    ((DWORD)0xEFFF00AEL)

//
// MessageId: IDS_SSCE_READ_ONLY_LEXICON_ERR
//
// MessageText:
//
//  The lexicon cannot be modified (probably a compressed lexicon).
//
#define IDS_SSCE_READ_ONLY_LEXICON_ERR   ((DWORD)0xEFFF00AFL)

//
// MessageId: IDS_SSCE_OUT_OF_MEMORY_ERR
//
// MessageText:
//
//  An attempt to allocate memory failed.
//
#define IDS_SSCE_OUT_OF_MEMORY_ERR       ((DWORD)0xEFFF00B0L)

//
// MessageId: IDS_SSCE_UNSUPPORTED_ACTION_ERR
//
// MessageText:
//
//  The requested action is not currently supported.
//
#define IDS_SSCE_UNSUPPORTED_ACTION_ERR  ((DWORD)0xEFFF00B1L)

//
// MessageId: IDS_SSCE_LEXICON_EXISTS_ERR
//
// MessageText:
//
//  The lexicon file name specified in a create operation already exists.
//
#define IDS_SSCE_LEXICON_EXISTS_ERR      ((DWORD)0xEFFF00B2L)

//
// MessageId: IDS_SSCE_BAD_BLOCK_ID_ERR
//
// MessageText:
//
//  The block id does not correspond to an open block.
//
#define IDS_SSCE_BAD_BLOCK_ID_ERR        ((DWORD)0xEFFF00B3L)

//
// MessageId: IDS_SSCE_CANCEL_ERR
//
// MessageText:
//
//  The user canceled (returned by functions in the Sentry Windows API only).
//
#define IDS_SSCE_CANCEL_ERR              ((DWORD)0xEFFF00B4L)

//
// MessageId: IDS_SSCE_INVALID_WORD_ERR
//
// MessageText:
//
//  A word was encountered which is more than SSCE_MAX_WORD_LEN characters long or contains unprintable characters.
//
#define IDS_SSCE_INVALID_WORD_ERR        ((DWORD)0xEFFF00B5L)

//
// MessageId: IDS_SSCE_WORD_OUT_OF_SEQUENCE_ERR
//
// MessageText:
//
//  During compression, a word was encountered which is either identical to the preceding word or lower in the collating sequence.
//
#define IDS_SSCE_WORD_OUT_OF_SEQUENCE_ERR ((DWORD)0xEFFF00B6L)

//
// MessageId: IDS_SSCE_FILE_READ_ERR
//
// MessageText:
//
//  An I/O error occurred while reading from a file.
//
#define IDS_SSCE_FILE_READ_ERR           ((DWORD)0xEFFF00B7L)

//
// MessageId: IDS_SSCE_FILE_WRITE_ERR
//
// MessageText:
//
//  An I/O error occurred while writing to a file.
//
#define IDS_SSCE_FILE_WRITE_ERR          ((DWORD)0xEFFF00B8L)

//
// MessageId: IDS_SSCE_FILE_OPEN_ERR
//
// MessageText:
//
//  A file could not be opened. Possibly the file doesn't exist, or is protected.
//
#define IDS_SSCE_FILE_OPEN_ERR           ((DWORD)0xEFFF00B9L)

//
// MessageId: IDS_SSCE_BUSY_ERR
//
// MessageText:
//
//  (Sentry Windows API only) One of the dialogs is already being displayed.
//
#define IDS_SSCE_BUSY_ERR                ((DWORD)0xEFFF00BAL)

//
// MessageId: IDS_SSCE_UNKNOWN_LEX_FORMAT_ERR
//
// MessageText:
//
//  The format of the lexicon file could not be determined.
//
#define IDS_SSCE_UNKNOWN_LEX_FORMAT_ERR  ((DWORD)0xEFFF00BBL)

//
// MessageId: IDS_INVALIDDIARY
//
// MessageText:
//
//  The selected file is not a valid Top Secret Journal.
//
#define IDS_INVALIDDIARY                 ((DWORD)0xEFFF00BCL)

//
// MessageId: IDS_NOADMINDIARY
//
// MessageText:
//
//  This Journal File requires an active and valid Administrator Account on this computer in order for you to open it.
//
#define IDS_NOADMINDIARY                 ((DWORD)0xEFFF00BDL)

//
// MessageId: IDS_NOTSINGLEUSER
//
// MessageText:
//
//  This Journal was created under a Single User License and cannot be opened under an Administrator Account.
//
#define IDS_NOTSINGLEUSER                ((DWORD)0xEFFF00BEL)

//
// MessageId: IDS_NOSECRETKEYFORDIARY
//
// MessageText:
//
//  The Secret Key required to access this journal is not on the currently loaded set of key rings.
//
#define IDS_NOSECRETKEYFORDIARY          ((DWORD)0xEFFF00BFL)

//
// MessageId: IDS_NOTRIALDIARY
//
// MessageText:
//
//  A Journal cannot be created or opened under an Active Administrator Account during the Trial Period.
//
#define IDS_NOTRIALDIARY                 ((DWORD)0xEFFF00C0L)

//
// MessageId: IDS_DIARYKEYNOGOOD
//
// MessageText:
//
//  An unrecognized version, encrypted integer too large, or an unknown encryption algorithm encountered in the key used to encrypt the Journal or Journal page. The procedure is cancelled.
//
#define IDS_DIARYKEYNOGOOD               ((DWORD)0xEFFF00C1L)

//
// MessageId: IDS_INVALIDDIARYPAGE
//
// MessageText:
//
//  An invalid Journal Page was encountered. Possible corrupted Journal File. The procedure is cancelled.
//
#define IDS_INVALIDDIARYPAGE             ((DWORD)0xEFFF00C2L)

//
// MessageId: IDS_TREEVIEWINSERTERROR
//
// MessageText:
//
//  An error occurred while inserting an item into the Tree View structure. Most likely due to insufficient memory. The procedure is cancelled.
//
#define IDS_TREEVIEWINSERTERROR          ((DWORD)0xEFFF00C3L)

//
// MessageId: IDS_INVALIDINDEXENTRY
//
// MessageText:
//
//  An invalid entry in the index file was encountered. Possible corrupted index file. The procedure is cancelled.
//
#define IDS_INVALIDINDEXENTRY            ((DWORD)0xEFFF00C4L)

//
// MessageId: IDS_EXPECTEDCOMPRESSEDDIARYPAGE
//
// MessageText:
//
//  Expected data to decompress after decrypting a Journal Page. Possible corrupted Journal File. The procedure is cancelled.
//
#define IDS_EXPECTEDCOMPRESSEDDIARYPAGE  ((DWORD)0xEFFF00C5L)

//
// MessageId: IDS_DIARYPAGECRC32NOGOOD
//
// MessageText:
//
//  The CRC32 Check Value for the Journal Page is invalid. Possible data corruption in the Journal File. The procedure is cancelled.
//
#define IDS_DIARYPAGECRC32NOGOOD         ((DWORD)0xEFFF00C6L)

//
// MessageId: IDS_DIARYDATEINVALID
//
// MessageText:
//
//  Your computers current date and time is less than the last entry made in the Journal. See the Open a Top Secret Journal help topic for more information. The procedure is cancelled.
//
#define IDS_DIARYDATEINVALID             ((DWORD)0xEFFF00C7L)

//
// MessageId: IDS_NOMAPIDLLFOREMAILCLIENT
//
// MessageText:
//
//  Your currently active e-mail client, %s, does not use or support a Simple MAPI dll. The various e-mail procedures will not be available for use.
//
#define IDS_NOMAPIDLLFOREMAILCLIENT      ((DWORD)0xEFFF00C8L)

//
// MessageId: IDS_REPLACEEXISITINGFILE
//
// MessageText:
//
//  The file you are trying to create already exists. Do you want to delete the file and create a new one with the same name?
//
#define IDS_REPLACEEXISITINGFILE         ((DWORD)0xEFFF00C9L)

